//-----------------------------------------------------------------------------
//Copyright  2000-2003 TogetherSoft Corporation, a wholly owned subsidiary of Borland Software Corporation. All rights reserved. All patents pending.
//-----------------------------------------------------------------------------
namespace CSCashSales.data_objects
{
    using System;
	using System.Collections;

	/// <summary>
	/// This is the container of products.
	/// It implements IProductContainer interface.
	/// </summary>
	/// <TgData>
	/// </TgData>
    public class ProductContainer : IProductContainer
    {
		/// <summary>
		/// The container.
		/// </summary>
		private ArrayList m_objList;

		/// <summary>
		/// Constructor.
		/// </summary>
        public ProductContainer()
        {
            m_objList = new ArrayList();
			fillProducts();
        }

		/// <summary>
		/// Returns a number of data items.
		/// </summary>
		public int getCount() 
		{
			return m_objList.Count;
		}

		/// <summary>
		/// Gets a data item at the specified index.
		/// </summary>
		/// <param name="index"> The item index </param>
		public IDataItem getDataItemAt( int index ) 
		{
			return m_objList[index] as IDataItem;
		}

		/// <summary>
		/// Adds new data item.
		/// </summary>
		/// <param name="newItem"> The data item </param>
		public void addDataItem( IDataItem newItem ) 
		{
			m_objList.Add(newItem);
		}

		/// <summary>
		/// Generates new free ID.
		/// </summary>
        public int generateID() 
		{
			int result = 1;
			for(int i=0; i<getCount(); i++)
			{
				IDataItem item = getDataItemAt(i);
				if(item.getID() > result)
					result = item.getID();
			}
			result++;
			return result;
		}

		/// <summary>
		/// Gets a product at the specified index.
		/// </summary>
		/// <param name="index"> The product index </param>
		public IProduct getProductAt( int index ) 
		{
			return getDataItemAt(index) as IProduct;
		}

		/// <summary>
		/// Creates new product.
		/// </summary>
		/// <param name="strName"> the product name </param>
		/// <param name="strUnitName"> the product unit name </param>
		/// <param name="dcmPrice"> the product price </param>
		private IProduct createNewProduct( String strName, String strUnitName, Decimal dcmPrice ) 
		{
			int id = generateID();
			Product objPrd = new Product(id, strName, strUnitName, dcmPrice);
			addDataItem( objPrd );
			return objPrd;
		}

		/// <summary>
		/// Fills the container by sample products.
		/// </summary>
		private void fillProducts() 
		{
			createNewProduct( "Pepsi 24-pack", "bottle", new Decimal(3.99) );
			createNewProduct( "Lays Ridges", "package", new Decimal(1.99) );
			createNewProduct( "Vienna Sausages", "can", new Decimal(2.99) );
			createNewProduct( "White Popcorn", "package", new Decimal(1.29) );
			createNewProduct( "Soy Burgers", "box", new Decimal(5.99) );
			createNewProduct( "Cat Chow", "can", new Decimal(9.99) );
			createNewProduct( "Puppy Chow", "can", new Decimal(12.99) );
			createNewProduct( "Finch Food", "box", new Decimal(1.59) );
			createNewProduct( "Rice Krispies", "box", new Decimal(3.29) );
			createNewProduct( "Fruit Loops", "package", new Decimal(3.49) );
		}

    }
}
